Rem
Rem $Header: sdo/demo/TIN/examples/plsql/tin.sql /main/6 2012/09/26 10:12:11 mhorhamm Exp $
Rem
Rem tin.sql
Rem
Rem Copyright (c) 2005, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      tin.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rkothuri    06/04/07 - add error handling notes
Rem    rkothuri    01/30/07 - Triangulated Irregular Network example
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

create table inptab (
  rid varchar2(24),
  val_d1 number,
  val_d2 number,
  val_d3 number) NOLOGGING;

create table tins (
  tin_id number,
  tin sdo_tin);

create table tin_blocks as select * from mdsys.sdo_tin_blk_table where rownum < 0;

alter table tins add primary key(tin_id);

-- Simplistic data set
begin
  for y in 0..999 loop
    for x in 0..999 loop
      insert into inptab (rid, val_d1, val_d2, val_d3) values (1000*y + x, x, y, x + y);
    end loop;
  end loop;
end;
/

commit;

declare
  tin sdo_tin;
begin
  tin :=
    sdo_tin_pkg.init(
      'TINS',
      'TIN',
      'TIN_BLOCKS',
      'blk_capacity=100000',
      mdsys.sdo_geometry(
        2003,
        27700,
        null,
        mdsys.sdo_elem_info_array(
          1, 1003, 3),
        mdsys.sdo_ordinate_array(
            0,   0,
          999, 999)),
      0.05,
      3,
      null);

  sdo_tin_pkg.create_tin(
    tin,
    'INPTAB');

  insert into tins values (1, tin);
end;
/

commit;

select
  num_points,
  num_triangles
from
  table(
    sdo_tin_pkg.clip_tin(
      inp         => (select tin from tins where tin_id = 1),
      qry         => sdo_geometry(
                       2003,
                       27700,
                       null,
                       mdsys.sdo_elem_info_array(1, 1003, 3),
                       mdsys.sdo_ordinate_array(1.1, 1.1,   1.9, 1.9)),
      qry_min_res => null,
      qry_max_res => null));

-- Result:
--
-- NUM_POINTS NUM_TRIANGLES
-- ---------- -------------
--          4             2
--

select
  blk_id,
  sdo_tin_pkg.to_geometry(
    pts         => points,
    trs         => triangles,
    num_pts     => num_points,
    num_trs     => num_triangles,
    TIN_IND_DIM => 2,
    TIN_TOT_DIM => 3,
    SRID        => null,
    BLK_DOMAIN  => null,
    GET_IDS     => 1)
from
  table(
    sdo_tin_pkg.clip_tin(
      inp         => (select tin from tins where tin_id = 1),
      qry         => sdo_geometry(
                       2003,
                       27700,
                       null,
                       mdsys.sdo_elem_info_array(1, 1003, 3),
                       mdsys.sdo_ordinate_array(1.1, 1.1,   1.9, 1.9)),
      qry_min_res => null,
      qry_max_res => null));

-- Result:
--
--     BLK_ID
-- ----------
-- SDO_TIN_PKG.TO_GEOMETRY(PTS=>POINTS,TRS=>TRIANGLES,NUM_PTS=>NUM_POINTS,NUM_TRS=>
-- --------------------------------------------------------------------------------
--         10
-- SDO_GEOMETRY(
--   5004,
--   NULL,
--   NULL,
--   SDO_ELEM_INFO_ARRAY(
--     1, 1003, 1,
--     21, 1003, 1),
--   SDO_ORDINATE_ARRAY(
--     1, 1, 2,  10, 137,
--     2, 1, 3,  10, 163,
--     2, 2, 4,  10, 238,
--     1, 1, 2,  10, 137,
--
--     1, 1, 2,  10, 137,
--     2, 2, 4,  10, 238,
--     1, 2, 3,  10, 212,
--     1, 1, 2,  10, 137))

create table raster_table (id number, raster_image sdo_georaster);

create table raster_data_table of sdo_raster
  (primary key (rasterId, pyramidLevel, bandBlockNumber, rowBlockNumber, columnBlockNumber))
  lob(rasterblock) store as (nocache nologging);

declare
  inp sdo_tin;
  geor sdo_georaster;
begin
  select tin INTO inp from tins where tin_id=1;
  insert into raster_table values (1, sdo_geor.init('raster_data_table')) returning raster_image into geor;
  sdo_tin_pkg.to_dem(
    tin                 => inp,
    dem                 => geor,
    blocksize           => 128,
    crs_units_per_pixel => 1.0);
  update raster_table set raster_image = geor where id = 1;
end;
/

select count(*) from raster_table;
select count(*) from raster_data_table;

drop table raster_table;
drop table raster_data_table;
drop table tins;
drop table tin_blocks;
drop table inptab;

exit;
